<?php

class USIN_Privacy{

	public static function init(){
		if(self::wp_supports_privacy()){
			USIN_Privacy_Exporter::init();
			USIN_Privacy_Eraser::init();

			add_filter('usin_module_options', array(__CLASS__ , 'register_privacy_module'));
			add_action('admin_init', array( __CLASS__, 'add_privacy_message'));
		}
	}

	public static function wp_supports_privacy(){
		$version = get_bloginfo('version');
		$min_version = '4.9.6';
		//use strpos to also check for 4.9.6 beta/RC versions, such as 4.9.6-RC2 as this doesn't work with version_compare
		if(version_compare( $version, $min_version, '>=' ) || strpos($version, $min_version) === 0){
			return true;
		}
		return false;
	}

	public static function register_privacy_module($modules){
		if(is_array($modules)){
			$privacy_module = self::get_privacy_module_options();
			array_splice( $modules, 1, 0, array($privacy_module));
		}

		return $modules;
	}

	/**
	 * Retrieves the name of a Users Insights field by field ID.
	 *
	 * @param string $field_id the field ID
	 * @return string the name of the field if it is found or the field ID
	 * if it is not found
	 */
	public static function get_field_name($field_id){
		$fields = USIN_Field_Defaults::get_fields();

		foreach ($fields as $field ) {
			if($field['id'] == $field_id){
				return $field['name'];
			}
		}

		return $field_id;
	}

	public static function add_privacy_message() {
		if (!function_exists( 'wp_add_privacy_policy_content' ) ) {
			return;
		}

		$content = self::get_privacy_message();
		wp_add_privacy_policy_content( 'Users Insights', self::get_privacy_message() );
	}

	protected static function get_privacy_message(){
		$message = '<div class="wp-suggested-text">';
		$message .= '<p class="privacy-policy-tutorial">'.__('This sample language includes the basics around what personal data 
		 	Users Insights may be detecting and storing. Depending on which modules are enabled, 
			the specific information detected by Users Insights will vary. If you do not have a 
			good reason for having any of the user data detection modules active, we recommend
			keeping them inactive. We also recommend consulting 
			with a lawyer when deciding what information to disclose on your privacy policy.', 'usin').'</p>';

		$message .= sprintf('<p><strong class="privacy-policy-tutorial">%s</strong><br/> %s</p>', 
			__('Suggested text when the Geolocation module is active:', 'usin'), 
			__('We will track your location based on your IP address in order to [enter reason here]. '.
				'To detect your location, we will send your IP address to the geolocation services of usersinsights.com. '.
				'We will store the country, region, city and coordinates associated with your IP address. '.
				'We will also store your IP address in a hashed format so we can check it for changes.' , 'usin'));

		$message .= sprintf('<p><strong class="privacy-policy-tutorial">%s</strong><br/> %s</p>', 
			__('Suggested text when the Activity module is active:', 'usin'), 
			__('We will track your last login date and number of sessions in order to [enter reason here].', 'usin'));

		$message .= sprintf('<p><strong class="privacy-policy-tutorial">%s</strong><br/> %s</p>', 
			__('Suggested text when the Device Detection module is active:', 'usin'), 
			__('We will track your browser name, browser version and device platform in order to [enter reason here].', 'usin'));

			$message .= sprintf('<p><strong class="privacy-policy-tutorial">%s</strong><br/> %s</p>', 
			__('Suggested text when the Page Visit Tracking module is active:', 'usin'), 
			__('We will track the pages that you visit in order to [enter reason here].', 'usin'));


		$message .= '</div>';

		return $message;
	}

	protected static function get_privacy_module_options(){
		return array(
			'id' => 'privacy',
			'name' => __('Privacy Settings', 'usin'),
			'desc' => __('Configure the privacy settings of Users Insights.', 'usin'),
			'allow_deactivate' => false,
			'active_by_default' => true,
			'settings' => array(
				'export_data' => array(
					'name' => __('Users Insights data to include in the WordPress personal data export file', 'usin'),
					'type' => USIN_Settings_Field::TYPE_CHECKBOXES,
					'desc' => __('Select which Users Insights data to include in the Personal Data Export file, generated by WordPress under Tools -> Export Personal Data', 'usin'),
					'options' => array(
						'geolocation' => __('Geolocation', 'usin'),
						'device' => __('Device info', 'usin'),
						'last_seen_sessions' => __('Last seen & sessions', 'usin'),
						'visits' => __('Pages visited', 'usin'),
						'groups' => __('User groups', 'usin'),
						'notes' => __('User notes', 'usin'),
						'custom_fields' => __('Users Insights custom fields', 'usin'),
						'hashed_ip' => __('Hashed IP address (geolocation module)')
					),
					'default' => array('geolocation', 'device', 'last_seen_sessions', 'visits')
				),
				'erase_data' => array(
					'name' => __('Users Insights data to erase upon Personal Data Erase request', 'usin'),
					'type' => USIN_Settings_Field::TYPE_CHECKBOXES,
					'desc' => __('Select which Users Insights data to be erased upon erase request, under Tools -> Erase Personal Data', 'usin'),
					'options' => array(
						'geolocation' => __('Geolocation', 'usin'),
						'device' => __('Device info', 'usin'),
						'last_seen_sessions' => __('Last seen & sessions', 'usin'),
						'visits' => __('Pages visited', 'usin'),
						'groups' => __('User groups', 'usin'),
						'notes' => __('User notes', 'usin'),
						'custom_fields' => __('Users Insights custom fields', 'usin'),
					),
					'default' => array('geolocation', 'device', 'last_seen_sessions', 'visits'),
				),
			),
			'buttons' => array(
				array('text'=> __('Learn More', 'usin'), 'link'=>'https://usersinsights.com/gdpr/', 'target'=>'_blank')
			)
		);
	}


}